function sigmoid(x)
{
  return Math.exp(x) / (Math.exp(x) + 1)
}

function update_slider()
{
  var val_weight = document.getElementById("id_weight").value;
  var val_height = document.getElementById("id_height").value;
  document.getElementById("id_op_body_weight").innerHTML = val_weight;
  document.getElementById("id_op_body_height").innerHTML = val_height;
  if (document.getElementById("id_checkbox").checked){
     document.getElementById("id_op_formula_h1").innerHTML = "h1 = beschraenke(0.67 * (" + val_weight + " - 64) + 1.87 * (" + val_height + " - 170) - 0.36)";
     document.getElementById("id_op_formula_h2").innerHTML = "h2 = beschraenke(1.33 * (" + val_weight + " - 64) - 0.43 * (" + val_height + " - 170) - 1.22)";
  }
  else {
     document.getElementById("id_op_formula_h1").innerHTML = "";
     document.getElementById("id_op_formula_h2").innerHTML = ""; 
  }
  var h1 = sigmoid(0.67 * (parseInt(val_weight)-64) + 1.87 * (parseInt(val_height)-170) - 0.36);
  var h2 = sigmoid(1.33 * (parseInt(val_weight)-64) - 0.43 * (parseInt(val_height)-170) - 1.22);
  document.getElementById("id_op_h1").innerHTML = h1.toFixed(4);
  document.getElementById("id_op_h2").innerHTML = h2.toFixed(4);
  if (document.getElementById("id_checkbox").checked){
     document.getElementById("id_op_formula_o1").innerHTML = "o1 = beschraenke(-3.18 * " + h1.toFixed(4) + " - 2.93 * " + h2.toFixed(4) + " + 2.92)";
  } else {
	 document.getElementById("id_op_formula_o1").innerHTML = "";
  } 
  var o1 = sigmoid(-3.18 * parseFloat(h1) - 2.93 * parseFloat(h2) + 2.92);
  document.getElementById("id_op_o1").innerHTML = o1.toFixed(4);
  //---
  var col_bw = Math.floor(255 * val_weight / 250);
  //console.log(fullColorHex(col, col, col));
  document.getElementById("id_node_bw").style.backgroundColor = "#" + fullColorHex(col_bw, col_bw, col_bw);
  var col_bh = Math.floor(255 * val_height / 250);
  document.getElementById("id_node_bh").style.backgroundColor = "#" + fullColorHex(col_bh, col_bh, col_bh);
  var col_h1 = Math.floor(255 * h1);
  document.getElementById("id_node_h1").style.backgroundColor = "#" + fullColorHex(col_h1, col_h1, col_h1);
  var col_h2 = Math.floor(255 * h2);
  document.getElementById("id_node_h2").style.backgroundColor = "#" + fullColorHex(col_h2, col_h2, col_h2);
  var col_o1 = Math.floor(255 * o1);
  document.getElementById("id_node_o1").style.backgroundColor = "#" + fullColorHex(col_o1, col_o1, col_o1);
}

function rgbToHex(rgb) { 
  var hex = Number(rgb).toString(16);
  if (hex.length < 2) {
       hex = "0" + hex;
  }
  return hex;
}

function fullColorHex(r,g,b) {   //r, g, b: 0 to 255
  var red = rgbToHex(r);
  var green = rgbToHex(g);
  var blue = rgbToHex(b);
  return red+green+blue;
}
