# based on https://realpython.com/face-recognition-with-python/
# download and install opencv:
# pip install opencv-python
import cv2

cascadeFeatures = cv2.CascadeClassifier("haarcascade_frontalface_default.xml")

img = cv2.imread("edlris3.jpg")
img_gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)

detected_faces = cascadeFeatures.detectMultiScale(img_gray, scaleFactor=1.1, minNeighbors=5, minSize=(20, 20))
print("Number of faces detected: {0} ".format(len(detected_faces)))

for (x, y, w, h) in detected_faces:
    cv2.rectangle(img, (x, y), (x+w, y+h), (255, 0, 0), 2)

cv2.imshow("detected faces", img)
cv2.waitKey(0)